#ifndef REP_TIMEMODEL_SOURCE_H
#define REP_TIMEMODEL_SOURCE_H

// This is an autogenerated file.
// Do not edit this file, any changes made will be lost the next time it is generated.

#include <QtCore/qobject.h>
#include <QtCore/qdatastream.h>
#include <QtCore/qvariant.h>
#include <QtCore/qmetatype.h>

#include <QtRemoteObjects/qremoteobjectnode.h>
#include <QtRemoteObjects/qremoteobjectsource.h>

#include <QtCore>

class PresetInfo
{
    Q_GADGET

    Q_PROPERTY(int presetNumber READ presetNumber WRITE setPresetNumber)
    Q_PROPERTY(float frequency READ frequency WRITE setFrequency)
    Q_PROPERTY(QString stationName READ stationName WRITE setStationName)
public:
    PresetInfo() : _presetNumber(), _frequency(), _stationName() {}
    explicit PresetInfo(int presetNumber, float frequency, QString stationName) : _presetNumber(presetNumber), _frequency(frequency), _stationName(stationName) {}
    int presetNumber() const { return _presetNumber; }
    void setPresetNumber(int presetNumber) { if (presetNumber != _presetNumber) { _presetNumber = presetNumber; } }
    float frequency() const { return _frequency; }
    void setFrequency(float frequency) { if (frequency != _frequency) { _frequency = frequency; } }
    QString stationName() const { return _stationName; }
    void setStationName(QString stationName) { if (stationName != _stationName) { _stationName = stationName; } }
private:
    int _presetNumber;
    float _frequency;
    QString _stationName;
};

inline bool operator==(const PresetInfo &left, const PresetInfo &right) Q_DECL_NOTHROW {
    return left.presetNumber() == right.presetNumber() && left.frequency() == right.frequency() && left.stationName() == right.stationName();
}
inline bool operator!=(const PresetInfo &left, const PresetInfo &right) Q_DECL_NOTHROW {
    return !(left == right);
}

inline QDataStream &operator<<(QDataStream &ds, const PresetInfo &obj) {
    QtRemoteObjects::copyStoredProperties(&obj, ds);
    return ds;
}

inline QDataStream &operator>>(QDataStream &ds, PresetInfo &obj) {
    QtRemoteObjects::copyStoredProperties(ds, &obj);
    return ds;
}


class PresetData
{
    Q_GADGET

    Q_PROPERTY(QList<QString> bla READ bla WRITE setBla)
public:
    PresetData() : _bla() {}
    explicit PresetData(QList<QString> bla) : _bla(bla) {}
    QList<QString> bla() const { return _bla; }
    void setBla(QList<QString> bla) { if (bla != _bla) { _bla = bla; } }
private:
    QList<QString> _bla;
};

inline bool operator==(const PresetData &left, const PresetData &right) Q_DECL_NOTHROW {
    return left.bla() == right.bla();
}
inline bool operator!=(const PresetData &left, const PresetData &right) Q_DECL_NOTHROW {
    return !(left == right);
}

inline QDataStream &operator<<(QDataStream &ds, const PresetData &obj) {
    QtRemoteObjects::copyStoredProperties(&obj, ds);
    return ds;
}

inline QDataStream &operator>>(QDataStream &ds, PresetData &obj) {
    QtRemoteObjects::copyStoredProperties(ds, &obj);
    return ds;
}


class MinuteTimerSource : public QObject
{
    Q_OBJECT
    Q_CLASSINFO(QCLASSINFO_REMOTEOBJECT_TYPE, "MinuteTimer")
    Q_CLASSINFO(QCLASSINFO_REMOTEOBJECT_SIGNATURE, "416fffbfe53b0a0d6e09875ba659c76c9cae17ac")
    Q_PROPERTY(int hour READ hour WRITE setHour NOTIFY hourChanged)
    Q_PROPERTY(int minute READ minute WRITE setMinute NOTIFY minuteChanged)

public:
    explicit MinuteTimerSource(QObject *parent = nullptr) : QObject(parent)
    {
        qRegisterMetaType<PresetInfo>();
        qRegisterMetaTypeStreamOperators<PresetInfo>();
        qRegisterMetaType<PresetData>();
        qRegisterMetaTypeStreamOperators<PresetData>();
        qRegisterMetaType<QMap<QString, QString>>();
        qRegisterMetaTypeStreamOperators<QMap<QString, QString>>();

    }

public:
    virtual ~MinuteTimerSource() {}

    virtual int hour() const = 0;
    virtual int minute() const = 0;
    virtual void setHour(int hour) = 0;
    virtual void setMinute(int minute) = 0;

Q_SIGNALS:
    void hourChanged(int);
    void minuteChanged(int);
    void timeChanged();
    void timeChanged2(const QTime & t);
    void sendCustom(PresetInfo info);
    void foo(QMap<QString, QString> foo);

public Q_SLOTS:
    virtual void pushHour(int hour)
    {
        setHour(hour);
    }
    virtual void pushMinute(int minute)
    {
        setMinute(minute);
    }
    virtual void SetTimeZone(const int & __repc_variable_1) = 0;

private:
    friend class QT_PREPEND_NAMESPACE(QRemoteObjectNode);
};

#if (QT_VERSION < QT_VERSION_CHECK(5, 5, 0))
#endif


class MinuteTimerSimpleSource : public QObject
{
    Q_OBJECT
    Q_CLASSINFO(QCLASSINFO_REMOTEOBJECT_TYPE, "MinuteTimer")
    Q_CLASSINFO(QCLASSINFO_REMOTEOBJECT_SIGNATURE, "416fffbfe53b0a0d6e09875ba659c76c9cae17ac")
    Q_PROPERTY(int hour READ hour WRITE setHour NOTIFY hourChanged)
    Q_PROPERTY(int minute READ minute WRITE setMinute NOTIFY minuteChanged)

public:
    explicit MinuteTimerSimpleSource(QObject *parent = nullptr) : QObject(parent)
        , _hour(1)
        , _minute(51)
    {
        qRegisterMetaType<PresetInfo>();
        qRegisterMetaTypeStreamOperators<PresetInfo>();
        qRegisterMetaType<PresetData>();
        qRegisterMetaTypeStreamOperators<PresetData>();
        qRegisterMetaType<QMap<QString, QString>>();
        qRegisterMetaTypeStreamOperators<QMap<QString, QString>>();

    }

public:
    virtual ~MinuteTimerSimpleSource() {}

    virtual int hour() const { return _hour; }
    virtual int minute() const { return _minute; }
    virtual void setHour(int hour)
    {
        if (hour != _hour) { 
            _hour = hour;
            Q_EMIT hourChanged(_hour);
        }
    }
    virtual void setMinute(int minute)
    {
        if (minute != _minute) { 
            _minute = minute;
            Q_EMIT minuteChanged(_minute);
        }
    }

Q_SIGNALS:
    void hourChanged(int);
    void minuteChanged(int);
    void timeChanged();
    void timeChanged2(const QTime & t);
    void sendCustom(PresetInfo info);
    void foo(QMap<QString, QString> foo);

public Q_SLOTS:
    virtual void pushHour(int hour)
    {
        setHour(hour);
    }
    virtual void pushMinute(int minute)
    {
        setMinute(minute);
    }
    virtual void SetTimeZone(const int & __repc_variable_1) = 0;

private:
    int _hour;
    int _minute;

private:
    friend class QT_PREPEND_NAMESPACE(QRemoteObjectNode);
};

#if (QT_VERSION < QT_VERSION_CHECK(5, 5, 0))
#endif


template <class ObjectType>
struct MinuteTimerSourceAPI : public SourceApiMap
{
    MinuteTimerSourceAPI(ObjectType *object)
        : SourceApiMap()
    {
        Q_UNUSED(object);
        _properties[0] = 2;
        _properties[1] = qtro_prop_index<ObjectType>(&ObjectType::hour, static_cast<int (QObject::*)()>(0),"hour");
        qtro_method_test<ObjectType>(&ObjectType::hourChanged, static_cast<void (QObject::*)()>(0));
        _properties[2] = qtro_prop_index<ObjectType>(&ObjectType::minute, static_cast<int (QObject::*)()>(0),"minute");
        qtro_method_test<ObjectType>(&ObjectType::minuteChanged, static_cast<void (QObject::*)()>(0));
        _signals[0] = 6;
        _signals[1] = qtro_signal_index<ObjectType>(&ObjectType::hourChanged, static_cast<void (QObject::*)()>(0),signalArgCount+0,&signalArgTypes[0]);
        _signals[2] = qtro_signal_index<ObjectType>(&ObjectType::minuteChanged, static_cast<void (QObject::*)()>(0),signalArgCount+1,&signalArgTypes[1]);
        _signals[3] = qtro_signal_index<ObjectType>(&ObjectType::timeChanged, static_cast<void (QObject::*)()>(0),signalArgCount+0,&signalArgTypes[0]);
        _signals[4] = qtro_signal_index<ObjectType>(&ObjectType::timeChanged2, static_cast<void (QObject::*)(QTime)>(0),signalArgCount+1,&signalArgTypes[1]);
        _signals[5] = qtro_signal_index<ObjectType>(&ObjectType::sendCustom, static_cast<void (QObject::*)(PresetInfo)>(0),signalArgCount+2,&signalArgTypes[2]);
        _signals[6] = qtro_signal_index<ObjectType>(&ObjectType::foo, static_cast<void (QObject::*)(QMap<QString,QString>)>(0),signalArgCount+3,&signalArgTypes[3]);
        _methods[0] = 3;
        _methods[1] = qtro_method_index<ObjectType>(&ObjectType::pushHour, static_cast<void (QObject::*)(int)>(0),"pushHour(int)",methodArgCount+0,&methodArgTypes[0]);
        _methods[2] = qtro_method_index<ObjectType>(&ObjectType::pushMinute, static_cast<void (QObject::*)(int)>(0),"pushMinute(int)",methodArgCount+1,&methodArgTypes[1]);
        _methods[3] = qtro_method_index<ObjectType>(&ObjectType::SetTimeZone, static_cast<void (QObject::*)(int)>(0),"SetTimeZone(int)",methodArgCount+2,&methodArgTypes[2]);
        _modelCount = 0;
    }

    QString name() const override { return QStringLiteral("MinuteTimer"); }
    QString typeName() const override { return QStringLiteral("MinuteTimer"); }
    int propertyCount() const override { return _properties[0]; }
    int signalCount() const override { return _signals[0]; }
    int methodCount() const override { return _methods[0]; }
    int modelCount() const override { return _modelCount; }
    int sourcePropertyIndex(int index) const override
    {
        if (index < 0 || index >= _properties[0])
            return -1;
        return _properties[index+1];
    }
    int sourceSignalIndex(int index) const override
    {
        if (index < 0 || index >= _signals[0])
            return -1;
        return _signals[index+1];
    }
    int sourceMethodIndex(int index) const override
    {
        if (index < 0 || index >= _methods[0])
            return -1;
        return _methods[index+1];
    }
    int signalParameterCount(int index) const override
    {
        if (index < 0 || index >= _signals[0])
            return -1;
        return signalArgCount[index];
    }
    int signalParameterType(int sigIndex, int paramIndex) const override
    {
        if (sigIndex < 0 || sigIndex >= _signals[0] || paramIndex < 0 || paramIndex >= signalArgCount[sigIndex])
            return -1;
        return signalArgTypes[sigIndex][paramIndex];
    }
    int methodParameterCount(int index) const override
    {
        if (index < 0 || index >= _methods[0])
            return -1;
        return methodArgCount[index];
    }
    int methodParameterType(int methodIndex, int paramIndex) const override
    {
        if (methodIndex < 0 || methodIndex >= _methods[0] || paramIndex < 0 || paramIndex >= methodArgCount[methodIndex])
            return -1;
        return methodArgTypes[methodIndex][paramIndex];
    }
    int propertyIndexFromSignal(int index) const override
    {
        switch (index) {
        case 0: return _properties[1];
        case 1: return _properties[2];
        }
        return -1;
    }
    int propertyRawIndexFromSignal(int index) const override
    {
        switch (index) {
        case 0: return 1;
        case 1: return 2;
        }
        return -1;
    }
    const QByteArray signalSignature(int index) const override
    {
        switch (index) {
        case 0: return QByteArrayLiteral("hourChanged()");
        case 1: return QByteArrayLiteral("minuteChanged()");
        case 2: return QByteArrayLiteral("timeChanged()");
        case 3: return QByteArrayLiteral("timeChanged2(QTime)");
        case 4: return QByteArrayLiteral("sendCustom(PresetInfo)");
        case 5: return QByteArrayLiteral("foo(QMap<QString,QString>)");
        }
        return QByteArrayLiteral("");
    }
    const QByteArray methodSignature(int index) const override
    {
        switch (index) {
        case 0: return QByteArrayLiteral("pushHour(int)");
        case 1: return QByteArrayLiteral("pushMinute(int)");
        case 2: return QByteArrayLiteral("SetTimeZone(int)");
        }
        return QByteArrayLiteral("");
    }
    QMetaMethod::MethodType methodType(int) const override
    {
        return QMetaMethod::Slot;
    }
    const QByteArray typeName(int index) const override
    {
        switch (index) {
        case 0: return QByteArrayLiteral("void");
        case 1: return QByteArrayLiteral("void");
        case 2: return QByteArrayLiteral("void");
        }
        return QByteArrayLiteral("");
    }
    QByteArray objectSignature() const override { return QByteArray{"416fffbfe53b0a0d6e09875ba659c76c9cae17ac"}; }

    int _properties[3];
    int _signals[7];
    int _methods[4];
    int signalArgCount[6];
    const int* signalArgTypes[6];
    int methodArgCount[3];
    const int* methodArgTypes[3];
    int _modelCount;
};
QT_BEGIN_NAMESPACE
QT_END_NAMESPACE


#endif // REP_TIMEMODEL_SOURCE_H
