;; $Id: dbgraph.dsl,v 1.1 1998/02/18 13:13:38 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ==================== GRAPHICS ====================

(define (graphic-file filename)
  (let ((ext (file-extension filename)))
    (if (or (not filename)
	    (not %graphic-default-extension%)
	    (member ext %graphic-extensions%))
	filename
	(string-append filename "." %graphic-default-extension%))))

(define ($img$ #!optional (nd (current-node)) (alt #f))
  (let* ((fileref (attribute-string "fileref" nd))
	 (entattr (attribute-string "entityref" nd))
	 (entityref (if entattr
			(entity-system-id entattr)
			#f))
	 (format  (attribute-string "format"))
	 (align   (attribute-string "align"))
	 (attr    (append 
		   (if align 
		       (list (list "ALIGN" align)) 
		       '())
		   (if entityref
		       (list (list "SRC" entityref))
		       (list (list "SRC" (graphic-file fileref))))
		   (if alt
		       (list (list "ALT" alt))
		       '()))))
    (make empty-element gi: "IMG"
	  attributes: attr)))

(element GRAPHIC
  (make element gi: "P"
	($img$)))

(element INLINEGRAPHIC
  ($img$))
