;; $Id: dblink.dsl,v 1.1 1998/02/18 13:13:43 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ========================= LINKS AND ANCHORS ==========================

(element LINK 
  (let* ((target (element-with-id 
		  (attribute-string "LINKEND"))))
    (if (node-list-empty? target)
	(process-children)
	(make element gi: "A"
	      attributes: (list
			   (list "HREF" (href-to target)))
	      (process-children)))))

(element OLINK ($charseq$))

(element ULINK 
  (make element gi: "A"
	attributes: (list
		     (list "HREF" (attribute-string "URL")))
	(process-children)))

(element ANCHOR
  (make element gi: "A"
	attributes: (list
		     (list "NAME" (attribute-string "ID")))
	(empty-sosofo)))

(element BEGINPAGE (empty-sosofo))

;; ======================================================================

(element XREF
  (let* ((endterm (attribute-string "ENDTERM"))
	 (linkend (attribute-string "LINKEND"))
	 (target  (element-with-id linkend)))
    (if (node-list-empty? target)
	(literal "[xref to non-existent element '" linkend "']")
	(make element gi: "A"
	      attributes: (list
			   (list "HREF" (href-to target)))
	      (if endterm
		  (if (node-list-empty? (element-with-id endterm))
		      (literal "[xref endterm to non-existent element '" endterm "']")
		      (with-mode xref-endterm-mode
			(process-node-list (element-with-id endterm))))
		  (if (attribute-string "XREFLABEL" target)
		      (xreflabel-sosofo (attribute-string "XREFLABEL" target))
		      (auto-xref target)))))))

(mode xref-endterm-mode
  (default
    (make element gi: "I"
	  (process-children-trim))))

(define (xreflabel-sosofo xreflabel)
  (make element gi: "I"
	(literal xreflabel)))

;; Returns the title of the element as a sosofo, italicized for xref.
;;
(define (element-title-xref-sosofo nd)
  (make element gi: "I"
	(element-title-sosofo nd)))

(mode xref-title-mode
  (default
    (process-children-trim)))

;; ======================================================================

(define (element-page-number-sosofo target)
  (with-mode pageno-mode
	(process-node-list target)))

(mode pageno-mode
  (default
    (current-node-page-number-sosofo)))

;; ======================================================================

