;; $Id: dbparam.dsl,v 1.1 1998/02/18 13:13:47 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/docbook/
;;

;; === Book intro, for dsl2man ==========================================

<![CDATA[
;; BOOKINFO
;; <bookinfo>
;; <title>DocBook HTML Parameters</title>
;; <subtitle>Part of the Modular DocBook Stylesheet distribution</subtitle>
;; <author><firstname>Norman</firstname><surname>Walsh</surname>
;; <affiliation><orgname>ArborText, Inc.</orgname></affiliation>
;; </author>
;; <edition>Reference version 1.02</edition>
;; <copyright><year>1997</year><year>1998</year>
;; <holder>Norman Walsh</holder></copyright>
;; <legalnotice>
;; <para>
;; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
;; EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
;; OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
;; NONINFRINGEMENT.  IN NO EVENT SHALL NORMAN WALSH OR ANY OTHER
;; CONTRIBUTOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
;; WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
;; FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
;; OTHER DEALINGS IN THE SOFTWARE.
;; </para>
;; </legalnotice>
;; <legalnotice>
;; <para>
;; Please direct all questions, bug reports, or suggestions for changes
;; to Norman Walsh, &lt;<literal>norm@berkshire.net</literal>&gt;.
;; </para>
;; <para>
;; See <ulink url="http://www.berkshire.net/~norm/dsssl/">http://www.berkshire.net/~norm/dsssl/</ulink> for more information.</para>
;; </legalnotice>
;; </bookinfo>
;; /BOOKINFO
]]>

;; ------------------------------ Parameters ------------------------------

(define %refentry-generate-name% 
  ;; REFENTRY
  ;; PURP Output NAME header before 'RefName'(s)?
  ;; DESC
  ;; If true, a "NAME" section title is output before the list
  ;; of 'RefName's.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #t)

(define %refentry-function% 
  ;; REFENTRY
  ;; PURP Are 'RefEntry's functions?
  ;; DESC
  ;; If true, 'RefEntry's are assumed to describe functions.
  ;; If 'RefEntry's are functions, "'()'"
  ;; is output after each 'RefName'
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #t)

(define %funcsynopsis-style% 
  ;; REFENTRY
  ;; PURP What style of 'FuncSynopsis' should be generated?
  ;; DESC
  ;; If '%funcsynopsis-style%' is 'ansi',
  ;; ANSI-style function synopses are generated for a 'FuncSynopsis',
  ;; otherwise K<![CDATA[&]]>R-style function synopses are generated.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  'ansi)

(define %ansi-funcsynopsis-indent% 
  ;; REFENTRY
  ;; PURP Indent-depth in ANSI-style function synopses
  ;; DESC
  ;; If the '%funcsynopsis-style%' is 'ansi',
  ;; '%ansi-funcsynopsis-indent%' specifies the amount by which parameter
  ;; definitions should be indented under the function prototype.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  1pi)

(define %default-simplesect-level% 
  ;; REFENTRY
  ;; PURP Default section level for 'SimpleSect's.
  ;; DESC
  ;; If 'SimpleSect's appear inside other section-level
  ;; elements, they are rendered at the appropriate section level, but if they
  ;; appear in a component-level element, they are rendered at 
  ;; '%default-simplesect-level%'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  4)

(define %generate-toc% 
  ;; REFENTRY
  ;; PURP Should a Table of Contents be produced?
  ;; DESC
  ;; If true, a Table of Contents will be generated for each 'Book'.
  ;; This parameter has no meaning except when 'Book's
  ;; are formatted.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #t)

(define $generate-chapter-toc$ 
  ;; REFENTRY
  ;; PURP Should a Chapter Table of Contents be produced?
  ;; DESC
  ;; If true, an automatically generated
  ;; chapter TOC should be included. By default, it's true.  It's false if
  ;; the output is going to a single file and the current node isn't the
  ;; root element.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  (lambda ()
    (or (not nochunks)
	(node-list=? (current-node) (sgml-root-element)))))

(define %force-chapter-toc% 
  ;; REFENTRY
  ;; PURP Force a chapter TOC even if it includes only a single entry
  ;; DESC
  ;; Force chapter toc indicates whether or not an automatically generated
  ;; chapter TOC should be included even if it has only one entry.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %generate-part-toc% 
  ;; REFENTRY
  ;; PURP Should a Part Table of Contents be produced?
  ;; DESC
  ;; If true, an automatically generated
  ;; chapter TOC should be included. By default, it's true.  It's false if
  ;; the output is going to a single file and the current node isn't the
  ;; root element.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  (lambda ()
    (or (not nochunks)
	(node-list=? (current-node) (sgml-root-element)))))

(define %generate-titlepage%
  ;; REFENTRY
  ;; PURP Should a book title page be produced?
  ;; DESC
  ;; If true, a title page will be generated for each 'Book'.
  ;; This parameter has no meaning except when 'Book's are formatted.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #t)

(define %generate-legalnotice-link%
  ;; REFENTRY
  ;; PURP Should legal notices be a link to a separate file?
  ;; DESC
  ;; If true, legal notices will be references to a separate file.
  ;; Note: the support for this handles the case where a single *INFO
  ;; node contains several distinct legal notices, but won't
  ;; handle multiple legal notices in different *INFO nodes.
  ;; (Each set will overwrite the previous.)  A more complex
  ;; approach could be implemented, but this is sufficient for
  ;; the current demand.  Let me know...
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %legalnotice-link-file%
  ;; REFENTRY
  ;; PURP Name of output file for legal notices
  ;; DESC
  ;; Name of the output file for legal notices if 
  ;; '%generate-legalnotice-link%' is true.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  (string-append "legal" %html-ext%))

(define %writing-mode%
  ;; REFENTRY
  ;; PURP The writing mode
  ;; DESC
  ;; The writing mode is either 'left-to-right', or 
  ;; 'right-to-left'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  'left-to-right)

(define %html-ext% 
  ;; REFENTRY
  ;; PURP Default extension for HTML output files
  ;; DESC
  ;; The default extension for HTML output files.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  ".htm")

(define %use-id-as-filename%
  ;; REFENTRY
  ;; PURP Use ID attributes as name for component HTML files?
  ;; DESC
  ;; If '%use-id-as-filename%' is true, the stylesheet will use the 
  ;; value of the ID attribute on a component as the base filename instead
  ;; of using the auto-generated base.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %section-autolabel%
  ;; REFENTRY
  ;; PURP Are sections enumerated?
  ;; DESC
  ;; If true, unlabeled sections will be enumerated.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %chapter-autolabel% 
  ;; REFENTRY
  ;; PURP Are chapters enumerated?
  ;; DESC
  ;; If true, chapters will be enumerated.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #t)

;; Should line numbers be printed on linespecific things?
;;
(define %number-synopsis-lines% 
  ;; REFENTRY
  ;; PURP Enumerate lines in a 'Synopsis'?
  ;; DESC
  ;; If true, lines in each 'Synopsis' will be enumerated.
  ;; See also '%linenumber-mod%', '%linenumber-length%', 
  ;; '%linenumber-padchar%', and '($linenumber-space$)'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %number-funcsynopsisinfo-lines% 
  ;; REFENTRY
  ;; PURP Enumerate lines in a 'FuncSynopsisInfo'?
  ;; DESC
  ;; If true, lines in each 'FuncSynopsisInfo' will be enumerated.
  ;; See also '%linenumber-mod%', '%linenumber-length%',
  ;; '%linenumber-padchar%', and '($linenumber-space$)'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %number-literallayout-lines% 
  ;; REFENTRY
  ;; PURP Enumerate lines in a 'LiteralLayout'?
  ;; DESC
  ;; If true, lines in each 'LiteralLayout' will be enumerated.
  ;; See also '%linenumber-mod%', '%linenumber-length%',
  ;; '%linenumber-padchar%', and '($linenumber-space$)'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %number-address-lines% 
  ;; REFENTRY
  ;; PURP Enumerate lines in a 'Address'?
  ;; DESC
  ;; If true, lines in each 'Address' will be enumerated.
  ;; See also '%linenumber-mod%', '%linenumber-length%',
  ;; '%linenumber-padchar%', and '($linenumber-space$)'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %number-programlisting-lines%
  ;; REFENTRY
  ;; PURP Enumerate lines in a 'ProgramListing'?
  ;; DESC
  ;; If true, lines in each 'ProgramListing' will be enumerated.
  ;; See also '%linenumber-mod%', '%linenumber-length%',
  ;; '%linenumber-padchar%', and '($linenumber-space$)'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %number-screen-lines%
  ;; REFENTRY
  ;; PURP Enumerate lines in a 'Screen'?
  ;; DESC
  ;; If true, lines in each 'Screen' will be enumerated.
  ;; See also '%linenumber-mod%', '%linenumber-length%',
  ;; '%linenumber-padchar%', and '($linenumber-space$)'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %linenumber-mod% 
  ;; REFENTRY
  ;; PURP Controls line-number frequency in enumerated environments.
  ;; DESC
  ;; Every '%linenumber-mod%' line will be enumerated.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  5)

(define %linenumber-length% 
  ;; REFENTRY
  ;; PURP Width of line numbers in enumerated environments
  ;; DESC
  ;; Line numbers will be padded to '%linenumber-length%'
  ;; characters.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  3)

(define %linenumber-padchar% 
  ;; REFENTRY
  ;; PURP Pad character in line numbers
  ;; DESC
  ;; Line numbers will be padded (on the left) with '%linenumber-padchar%'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  " ")

(define ($linenumber-space$) 
  ;; REFENTRY
  ;; PURP Returns the sosofo which separates line numbers from the text
  ;; DESC
  ;; The sosofo returned by '($linenumber-space$)' is placed
  ;; between the line number and the corresponding line in 
  ;; enumerated environments.
  ;;
  ;; Note: '%linenumber-padchar%'s are separated from lines
  ;; that are not enumerated (because they don't match '%linenumber-mod%').
  ;; In other words, '($linenumber-space$)' occurs
  ;; on every line.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  (make entity-ref name: "nbsp"))

(define %callout-default-col% 
  ;; REFENTRY
  ;; PURP Default column for callouts
  ;; DESC
  ;; If the coordinates of a callout include only a line number, the callout
  ;; bug will appear in column '%callout-default-col%'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  60)

(define %simplelist-column-width% 
  ;; REFENTRY
  ;; PURP Width of columns in tabular simple lists
  ;; DESC
  ;; If SimpleLists are presented in a table, how wide should the table
  ;; columns be?  If '#f', no width will be specified.
  ;;
  ;; If not #f, this value should be a string (it will be used in the WIDTH
  ;; attribute on the TD for each table entry).
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %graphic-default-extension% 
  ;; REFENTRY
  ;; PURP Default extension for graphic FILEREFs
  ;; DESC
  ;; The '%graphic-default-extension%' will be
  ;; added to the end of all 'fileref' filenames on
  ;; 'Graphic's if they do not end in one of the
  ;; '%graphic-extensions%'.  Set this to '#f'
  ;; to turn off this feature.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %graphic-extensions% 
  ;; REFENTRY
  ;; PURP List of graphic filename extensions
  ;; DESC
  ;; The list of extensions which may appear on a 'fileref'
  ;; on a 'Graphic' which are indicative of graphic formats.
  ;;
  ;; Filenames that end in one of these extensions will not have
  ;; the '%graphic-default-extension%' added to them.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  '("gif" "jpg" "jpeg" "tif" "tiff" "eps" "epsf" ))

(define nochunks
  ;; REFENTRY
  ;; PURP Suppress chunking of output pages
  ;; DESC
  ;; If true, the entire source document is formatted as a single HTML
  ;; document and output on stdout.
  ;; (This option can conveniently be set with '-V nochunks' on the 
  ;; Jade command line).
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %html-pubid%
  ;; REFENTRY
  ;; PURP What public ID are you declaring your HTML compliant with?
  ;; DESC
  ;; The public ID used in output HTML files.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  "-//W3C//DTD HTML 3.2//EN")

(define %html-meta-tags% 
  ;; REFENTRY
  ;; PURP What META should be generated?
  ;; DESC
  ;; A list of the the HTML META information that should be generated.
  ;; The format is a list of lists, each interior list contains the
  ;; name and value of an HTML META tag.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  (list
   ;; Creator is handled automatically with %stylesheet-version%
   ;; (list "creator" "DSSSL DocBook to HTML Style Sheet")
   (list "form" "html")))

(define %body-attr% 
  ;; REFENTRY
  ;; PURP What attributes should be hung off of BODY?
  ;; DESC
  ;; A list of the the BODY attributes that should be generated.
  ;; The format is a list of lists, each interior list contains the
  ;; name and value of a BODY attribute.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  (list
   (list "BGCOLOR" "#FFFFFF")
   (list "TEXT" "#000000")))

;;   With what attributes on
;; the table used to wrap the shading?
(define %shade-verbatim%  
  ;; REFENTRY
  ;; PURP Should verbatim environments be shaded?
  ;; DESC
  ;; If true, a table with '%shade-verbatim-attr%' attributes will be
  ;; wrapped around each verbatim environment.  This gives the effect
  ;; of a shaded verbatim environment.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

(define %shade-verbatim-attr% 
  ;; REFENTRY
  ;; PURP Attributes used to create a shaded verbatim environment.
  ;; DESC
  ;; See '%shade-verbatim%'
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  (list
   (list "BORDER" "0")
   (list "BGCOLOR" "#E0E0E0")
   (list "WIDTH" "100%")))

(define %spacing-paras%
  ;; REFENTRY
  ;; PURP Block-element spacing hack
  ;; DESC
  ;; Should extraneous "P" tags be output to force the correct vertical
  ;; spacing around things like tables.  This is ugly because different
  ;; browsers do different things.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #t)

(define %gentext-nav-use-tables%
  ;; REFENTRY
  ;; PURP Use tables to build the navigation headers and footers?
  ;; DESC
  ;; If true, HTML TABLEs will be used to format the header and footer
  ;; navigation information.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #t)

;; If so, how wide do you want them to be?
(define %gentext-nav-tblwidth% 
  ;; REFENTRY
  ;; PURP If using tables for navigation, how wide should the tables be?
  ;; DESC
  ;; If tables are used for navigation (see '%gentext-nav-use-tables%'),
  ;; how wide should the tables be?
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  "515")

(define %gentext-nav-use-ff%
  ;; REFENTRY
  ;; PURP Add "fast-forward" to the navigation links?
  ;; DESC
  ;; Do you want "fast-forward" navigation?  Probably not is my guess.
  ;; I'm not sure this works real well yet.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #f)

;; ----------------------------------------------------------------------
;;
;; Declare initial values; perhaps more should be done this way...
;;

(declare-initial-value writing-mode 	%writing-mode%)

