;; $Id: dbinline.dsl,v 1.1 1998/02/18 13:14:13 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ============================== INLINES ===============================

(element ACCEL ($charseq$))
(element ACTION ($charseq$))
(element APPLICATION ($charseq$))
(element CLASSNAME ($charseq$))
(element COMMAND ($bold-seq$))
(element COMPUTEROUTPUT ($mono-seq$))
(element DATABASE ($charseq$))
(element EMAIL ($charseq$))
(element ENVAR ($charseq$))
(element ERRORCODE ($charseq$))
(element ERRORNAME ($charseq$))
(element ERRORTYPE ($charseq$))
(element FILENAME ($mono-seq$))
(element FUNCTION ($bold-seq$))
(element GUIBUTTON ($guilabel-seq$))
(element GUIICON ($guilabel-seq$))
(element GUILABEL ($guilabel-seq$))
(element GUIMENU ($guilabel-seq$))
(element GUIMENUITEM ($guilabel-seq$))
(element GUISUBMENU ($guilabel-seq$))
(element HARDWARE ($charseq$))
(element INTERFACE ($charseq$))
(element INTERFACEDEFINITION ($charseq$))
(element KEYCAP ($bold-seq$))
(element KEYCODE ($charseq$))

(element KEYCOMBO 
  (let loop ((nl (children (current-node))) (count 1))
    (if (node-list-empty? nl)
	(empty-sosofo)
	(if (equal? count 1)
	    (make sequence
	      (process-node-list (node-list-first nl))
	      (loop (node-list-rest nl) (+ count 1)))
	    (make sequence
	      (literal "+")
	      (process-node-list (node-list-first nl))
	      (loop (node-list-rest nl) (+ count 1)))))))


(element KEYSYM ($charseq$))
(element LITERAL ($mono-seq$))
(element MEDIALABEL ($italic-seq$))
(element MENUCHOICE ($charseq$))
(element SHORTCUT ($bold-seq$))
(element MOUSEBUTTON ($charseq$))
(element OPTION ($charseq$))
(element OPTIONAL ($charseq$))
(element PARAMETER ($italic-mono-seq$))
(element PROPERTY ($charseq$))
(element PROMPT ($mono-seq$))
(element REPLACEABLE ($italic-mono-seq$))
(element RETURNVALUE ($charseq$))
(element STRUCTFIELD ($italic-mono-seq$))
(element STRUCTNAME ($charseq$))
(element SYMBOL ($charseq$))
(element SYSTEMITEM ($charseq$))
(element TOKEN ($charseq$))
(element TYPE ($charseq$))
(element USERINPUT ($bold-mono-seq$))
(element ABBREV ($charseq$))
(element ACRONYM ($charseq$))
(element CITATION ($charseq$))
(element CITEREFENTRY ($charseq$))
(element CITETITLE ($italic-seq$))
(element EMPHASIS ($italic-seq$))
(element FIRSTTERM ($italic-seq$))
(element FOREIGNPHRASE ($italic-seq$))
(element MARKUP ($charseq$))
(element PHRASE ($charseq$))

(element QUOTE
  (make sequence
    (literal %gentext-start-quote%)
    (process-children)
    (literal %gentext-end-quote%)))

(element SGMLTAG
  (let ((class (if (attribute-string "CLASS")
		   (attribute-string "CLASS")
		   "ELEMENT")))
    (case class
<![CDATA[
      (("ATTRIBUTE") ($charseq$))
      (("ATTVALUE") ($mono-seq$))
      (("ELEMENT") ($charseq$))
      (("ENDTAG") ($mono-seq$ (make sequence 
			       (literal "</") 
			       (process-children)
			       (literal ">"))))
      (("GENENTITY") ($mono-seq$ (make sequence
				    (literal "&")
				    (process-children)
				    (literal ";"))))
      (("NUMCHARREF") ($mono-seq$ (make sequence
				     (literal "&#")
				     (process-children)
				     (literal ";"))))
      (("PARAMENTITY") ($mono-seq$ (make sequence
				      (literal "%")
				      (process-children)
				      (literal ";"))))
      (("PI") ($mono-seq$ (make sequence 
			    (literal "<?")
			    (process-children)
			    (literal ">"))))
      (("STARTTAG") ($mono-seq$ (make sequence 
				  (literal "<") 
				  (process-children)
				  (literal ">"))))
      (("SGMLCOMMENT") ($mono-seq$ (make sequence 
				     (literal "<!--")
				     (process-children)
				     (literal "-->"))))
]]>
      (else ($charseq$)))))

(element TRADEMARK ($charseq$))
(element WORDASWORD ($italic-seq$))

(element LINEANNOTATION
  (make sequence
    font-family-name: %body-font-family%
    font-posture: 'italic
    (process-children)))

(define ($ss-seq$ plus-or-minus #!optional (sosofo (process-children)))
  (make sequence
	font-size:
	  (* (inherited-font-size) %ss-size-factor%)
	position-point-shift:
	  (plus-or-minus (* (inherited-font-size) %ss-shift-factor%))
	sosofo))

(element SUPERSCRIPT ($ss-seq$ +))
(element SUBSCRIPT ($ss-seq$ -))

(element COMMENT (empty-sosofo))

