#ifndef QADC_H
#define QADC_H

//----------------------------------
// Includes and forward declarations
//----------------------------------
#include <cyg/infra/cyg_type.h>

//--------------------------------------------------------------------------
// Type definitions for the Queued Analog to Digital Convertor on the MPC555
//--------------------------------------------------------------------------
typedef struct qadc64_port {
  volatile cyg_uint16 qadc64mcr;
  volatile cyg_uint16 qadc64test;
  volatile cyg_uint16 qadc64int;
  volatile cyg_uint16 portqa_portqb;
  volatile cyg_uint16 ddrqa_ddrqb;
  volatile cyg_uint16 qacr0;
  volatile cyg_uint16 qacr1;
  volatile cyg_uint16 qacr2;
  volatile cyg_uint16 qasr0;
  volatile cyg_uint16 qasr1;
  volatile cyg_uint16 unused[246];
  volatile cyg_uint16 ccw[64];
  volatile cyg_uint16 rjurr[64];
  volatile cyg_int16  ljsrr[64];
  volatile cyg_uint16 ljurr[64];
} qadc64_port_t;

//----------------------------------------------------------------
// And here is how we will build the adc interface using the quadc
//----------------------------------------------------------------
typedef struct qadc64_adc {
  qadc64_port_t * port;
  cyg_uint16      queuepos;
  cyg_uint16      channel;
} qadc64_adc_t;

#endif // QADC_H
