//==========================================================================
//
//      gmd.c
//
//      eCos interface to MOTOROLA General Market CMF driver for MPC555
//
//==========================================================================
//####COPYRIGHTBEGIN####
//                                                                          
// -------------------------------------------                              
// The contents of this file are subject to the Red Hat eCos Public License 
// Version 1.1 (the "License"); you may not use this file except in         
// compliance with the License.  You may obtain a copy of the License at    
// http://www.redhat.com/                                                   
//                                                                          
// Software distributed under the License is distributed on an "AS IS"      
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the 
// License for the specific language governing rights and limitations under 
// the License.                                                             
//                                                                          
// The Original Code is eCos - Embedded Configurable Operating System,      
// released September 30, 1998.                                             
//                                                                          
// The Initial Developer of the Original Code is Red Hat.                   
// Portions created by Red Hat are                                          
// Copyright (C) 1998, 1999, 2000 Red Hat, Inc.                             
// All Rights Reserved.                                                     
// -------------------------------------------                              
//                                                                          
//####COPYRIGHTEND####
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   Bob Koninckx
// Contributors:Bob Koninckx
// Date:        2001-12-22
// Purpose:     eCos interface to motorola General market CMF driver for 
//              MPC555
// Description:
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <cyg/io/gmd.h>

//---------------------------------------------------------------------------
// The binary driver functions by MOTOROLA

externC const unsigned int gmd_bc[];    // blank check
externC const unsigned int gmd_pe[];    // parallel erase
externC const unsigned int gmd_pi[];    // parallel init
externC const unsigned int gmd_pp[];    // parallel program

//---------------------------------------------
// Pass the call to the binary driver functions

// ParallelInit
cyg_uint8 ParallelInit(tCMF_PART *cmfPart)
{
  typedef cyg_uint8 (*pfParallelInit)(tCMF_PART *cmfPart);
  
  pfParallelInit func = (pfParallelInit) gmd_pi;
  return (*func)(cmfPart);
}

// ParallelErase
cyg_uint8 ParallelErase(tCMF_PART *cmfPart,
                        tCMF_ERASE_DATA *eraseData,
                        cyg_uint8 *enabledBlocks,
                        void (*CallBack)(void))
{
  typedef cyg_uint8 (*pfParallelErase)(tCMF_PART *cmfPart,
                                       tCMF_ERASE_DATA *eraseData,
                                       cyg_uint8 *enabledBlocks,
                                       void (*CallBack)(void));
  
  pfParallelErase func = (pfParallelErase) gmd_pe;
  return (*func)(cmfPart, eraseData, enabledBlocks, CallBack);
}

// BlankCheck
cyg_uint8 BlankCheck(tCMF_PART *cmfPart,
                     cyg_uint32 dest,
                     cyg_uint32 size,
                     cyg_uint8 shadow,
                     tCMF_COMP_DATA *cmfCompare,
                     void (*CallBack)(void))
{
  typedef cyg_uint8 (*pfBlankCheck)(tCMF_PART *cmfPart,
                                    cyg_uint32 dest,
                                    cyg_uint32 size,
                                    cyg_uint8 shadow,
                                    tCMF_COMP_DATA *cmfCompare,
                                    void (*CallBack)(void));
  
  pfBlankCheck func = (pfBlankCheck) gmd_bc;
  return (*func)(cmfPart, dest, size, shadow, cmfCompare, CallBack);
}

// ParallelProgram
cyg_uint8 ParallelProgram(tCMF_PART *cmfPart,
                          tCMF_PROGRAM_DATA *programData,
                          cyg_uint8 *enabledBlocks,
                          cyg_uint32 source,
                          cyg_uint32 offset,
                          cyg_uint16 pagesetNum,
                          cyg_uint8 shadow,
                          void (*CallBack)(void))
{
  typedef cyg_uint8 (*pfParallelProgram)(tCMF_PART *cmfPart,
                                         tCMF_PROGRAM_DATA *programData,
                                         cyg_uint8 *enabledBlocks,
                                         cyg_uint32 source,
                                         cyg_uint32 offset,
                                         cyg_uint16 pagesetNum,
                                         cyg_uint8 shadow,
                                         void (*CallBack)(void));
  
  pfParallelProgram func = (pfParallelProgram) gmd_pp;
  return (*func)(cmfPart, programData, enabledBlocks, source, offset, pagesetNum, shadow, CallBack);
}

// -------------------------------------------------------------------------
// EOF gmd.c
