//==========================================================================
//
//      arm9_misc.c
//
//      HAL misc board support code for ARM9
//
//==========================================================================
//####COPYRIGHTBEGIN####
//
// -------------------------------------------
// The contents of this file are subject to the Red Hat eCos Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License.  You may obtain a copy of the License at
// http://www.redhat.com/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the
// License for the specific language governing rights and limitations under
// the License. 
//
// The Original Code is eCos - Embedded Configurable Operating System,
// released September 30, 1998.
//
// The Initial Developer of the Original Code is Red Hat.
// Portions created by Red Hat are
// Copyright (C) 1998, 1999, 2000, 2001 Red Hat, Inc.
// All Rights Reserved.
// -------------------------------------------
//
//####COPYRIGHTEND####
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    gthomas
// Contributors: jskov
// Date:         2000-05-08
// Purpose:      HAL board support
// Description:  Implementations of HAL board interfaces
//
//####DESCRIPTIONEND####
//
//========================================================================*/

#include <pkgconf/hal.h>
#include <pkgconf/system.h>
#include CYGBLD_HAL_PLATFORM_H

#include <cyg/infra/cyg_type.h>         // base types

#include <cyg/hal/hal_if.h>             // HAL ROM/if
#include <cyg/hal/hal_io.h>             // IO macros
#include <cyg/hal/hal_cache.h>

// Most initialization has already been done before we get here.
// All we do here is enable the caches.

externC void plf_hardware_init(void);

void hal_hardware_init(void)
{
    // Perform any platform specific initializations
    plf_hardware_init();

    // Set up eCos/ROM interfaces
    hal_if_init();

    // Enable caches
    HAL_DCACHE_INVALIDATE_ALL();
    HAL_ICACHE_INVALIDATE_ALL();
#ifdef CYGSEM_HAL_ENABLE_DCACHE_ON_STARTUP
    HAL_DCACHE_ENABLE();
#endif
#ifdef CYGSEM_HAL_ENABLE_ICACHE_ON_STARTUP
    HAL_ICACHE_ENABLE();
#endif
}

void
cyg_hal_arm9_soft_reset(CYG_ADDRESS entry)
{

    /* It would probably make more sense to have the
       clear/drain/invalidate after disabling the cache and MMU, but
       then we'd have to know the (unmapped) address of this code. */
    asm volatile ("mov r1, #0;"
                  "mcr p15,0,r1,c7,c7,0;"  /* clear I+DCache */
                  "mcr p15,0,r1,c7,c10,4;" /* Drain Write Buffer */
                  "mcr p15,0,r1,c8,c7,0;"  /* Invalidate TLBs */
                  "mrc p15,0,r1,c1,c0,0;"
                  "bic r1,r1,#0x1000;"     /* disable ICache */
                  "bic r1,r1,#0x0007;"     /* disable DCache, MMU and alignment faults */
                  "mcr p15,0,r1,c1,c0,0;"
                  "nop;"                   /* delay 1 */
                  "mov pc, %0;"            /* delay 2  - next instruction should be fetched flat */
                  : : "r" (entry) : "r1");
    for(;;);
}

/*------------------------------------------------------------------------*/
// EOF arm9_misc.c
