/* Host definitions for GDB running on an alpha under VMS
   Copyright (C) 1992, 1993 Free Software Foundation, Inc.

This file is part of GDB.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#if !defined (HOST_BYTE_ORDER)
#define HOST_BYTE_ORDER LITTLE_ENDIAN
#endif

/* The alpha has no siginterrupt routine.  */
#define NO_SIGINTERRUPT

#define FILENAMEEQ(a,b) (!strcasecmp ((a), (b)))

#define FILENAMECOMP(a,b) (!evax_filename_comp ((a), (b)))
extern int evax_filename_comp();

#define GDBINIT_FILENAME "gdb.init"

#define GDBHISTORY_FILENAME "gdb.history"

#define TO_HOST_DIR_SPEC(DIRSPEC) \
vms_tovms_dir_spec (DIRSPEC)
extern char *vms_tovms_dir_spec();

#define TO_HOST_FILE_SPEC(FILESPEC) \
vms_tovms_file_spec (FILESPEC)
extern char *vms_tovms_file_spec();

#define TO_NORMAL_DIR_SPEC(DIRSPEC) \
vms_tounix_dir_spec (DIRSPEC)
extern char *vms_tounix_dir_spec();

#define TO_NORMAL_FILE_SPEC(FILESPEC) \
vms_tounix_file_spec (FILESPEC)
extern char *vms_tounix_file_spec();

#define TO_NORMAL_PATH_SPEC(PATHSPEC) \
vms_tounix_path_spec (PATHSPEC)
extern char *vms_tounix_path_spec();

#define DIRNAME_SEPARATOR ','
